<?php
include($_SERVER['DOCUMENT_ROOT'] . '/boletos/template/header.php');
echo ('<input id="id_sesion" hidden value="' . htmlspecialchars(session_id()) . '">');
?>

<style>
  @media screen and (max-width: 500px) {
    .imgresponsive {
      width: 100%;
      height: 100%;
    }
  }

  @media screen and (min-width: 700px) {
    .imgresponsive {
      width: 100%;
      height: 40%;
    }
  }
</style>

<main>
  <?php
  if (isset($_GET['evento']) && filter_var($_GET['evento'], FILTER_VALIDATE_INT)) {
      $evento_id = $_GET['evento'];

      $stmt = $mysqli->prepare("SELECT A.nombre as evento FROM evento A WHERE A.id = ? AND A.venderweb = 1 AND status = 1 AND fecha >= CURDATE()");
      $stmt->bind_param("i", $evento_id);
      $stmt->execute();
      $result = $stmt->get_result();

      while ($evento = $result->fetch_assoc()) {
          echo '<center><h1>' . htmlspecialchars($evento['evento']) . '</h1></center>';
      }
      $stmt->close();
  }
  ?>

  <div class="album py-5 bg-body-tertiary">
    <div class="container">
      <h2>Tipo de Localidades</h2>
      <div class="row">
        <div class="col-md-6">
          <?php
          if (isset($_GET['evento']) && filter_var($_GET['evento'], FILTER_VALIDATE_INT)) {
              $stmt = $mysqli->prepare(
                  "SELECT B.id, B.nombre, 
                  IF(A.tipo_precio = 1, B.precio_1, 
                  IF(A.tipo_precio = 2, B.precio_2, 
                  IF(A.tipo_precio = 3, B.precio_3, 
                  IF(A.tipo_precio = 4, B.precio_4, B.precio_5)))) AS precio, 
                  A.nombre as evento, B.mapa
                  FROM evento A 
                  INNER JOIN tipo_localidad B ON A.venue_id = B.venue_id AND B.venderweb = 1 
                  WHERE A.id = ? AND A.venderweb = 1 AND status = 1 AND fecha >= CURDATE()"
              );
              $stmt->bind_param("i", $evento_id);
              $stmt->execute();
              $result = $stmt->get_result();

              while ($valores = $result->fetch_assoc()) {
                  ?>
                  <div class="card col-md-6">
                    <div class="card-body">
                      <p class="card-text">
                        <?php echo '<label>' . htmlspecialchars($valores['nombre']) . '</label>'; ?>
                      </p>
                      <?php if ($valores['mapa'] == 1) { ?>
                        <p class="card-text"><input type="button" value="Mostrar Mapa" name="mostrarmapa" id="btnRegistrar"
                            class="registrar" tabindex="8" /></p>
                      <?php } ?>
                      <p class="card-text">
                        <?php echo '<label>Precio $ ' . htmlspecialchars($valores['precio']) . '</label>'; ?>
                      </p>
                      <div class="row">
                        <div class="btn-group">
                          <?php if (!empty($_SESSION["user_id"])) { ?>
                            <a href="web.php?evento=<?php echo urlencode($_GET['evento']); ?>&amp;tipolocalidad=<?php echo urlencode($valores['id']); ?>"
                              type="button" class="btn btn-lg btn-outline-danger botonevento">Comprar</a>
                          <?php } ?>
                        </div>
                      </div>
                    </div>
                  </div>
                  <?php
              }
              $stmt->close();
          }
          ?>
        </div>
        <div class="col-md-6">
          <img class="bd-placeholder-img card-img-top imgresponsive" src="../assets/img/MAPAAHG.png"
            usemap="#image-map">

          <map name="image-map" id="image-map">
            <area target="" alt="Sillas Centrales" title="Sillas Centrales"
              href="https://ticket.fullacceso.com/boletos/ventas/web.php?evento=<?php echo urlencode($_GET['evento']); ?>&amp;tipolocalidad=1"
              coords="206,3681,1310,3802" shape="rect">
            <area target="" alt="Gradas" title="Gradas"
              href="https://ticket.fullacceso.com/boletos/ventas/web.php?evento=<?php echo urlencode($_GET['evento']); ?>&amp;tipolocalidad=3"
              coords="1709,268,1723,533,897,846,733,671,1186,372" shape="poly">
            <area target="" alt="Sillas Laterales" title="Sillas Laterales"
              href="https://ticket.fullacceso.com/boletos/ventas/web.php?evento=<?php echo urlencode($_GET['evento']); ?>&amp;tipolocalidad=2"
              coords="1454,3677,2542,3805" shape="rect">
          </map>
        </div>
      </div>
    </div>
  </div>
</main>

<?php
include('../template/footer.php');
?>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="jquery.rwdImageMaps.min.js"></script>
<script>
  $(document).ready(function () {
    $('img[usemap]').rwdImageMaps();
    $(".registrar").click(function (e) {
      if (e.target.id == 'btnRegistrar') {
        $("#modal-title").text("Usuario creado correctamente");
      }
      $('#myModal').modal('show');
    });
    cancelar_venta();
  });

  function cancelar_venta() {
    var id_sesion = $('#id_sesion').val();
    var parametros = {
      "id_sesion": id_sesion
    };
    $.ajax({
      data: parametros,
      url: "cancelar_venta.php",
      type: "post",
      success: function (response) {
        console.log(response);
      }
    });
  }
</script>