import { useEffect, useRef, useState } from "react";
import axios from "axios";

// Styles
import "./QrStyles.css";

// Qr Scanner
import QrScanner from "qr-scanner";
import QrFrame from "../assets/qr-frame.svg";

import { ToastContainer, toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

import Swal from "sweetalert2";

/*const URL_API =
  "http://localhost/control_acceso/Backend-php/";*/
  
const URL_API =
  "http://ticket.fullacceso.com/control_acceso/Backend-php/";


const QrReader = () => {
  const [amigos, setAmigos] = useState([]);

  const [scannedResult, setScannedResult] = useState<string | undefined>("");

  useEffect(() => {
    // Obtener lista de contactos al cargar la página
    obtenerContactos();
  }, [scannedResult]);

  // QR States
  const scanner = useRef<QrScanner>();
  const videoEl = useRef<HTMLVideoElement>(null);
  const qrBoxEl = useRef<HTMLDivElement>(null);
  const [qrOn, setQrOn] = useState<boolean>(true);

  // Result


  // Success
  const onScanSuccess = (result: QrScanner.ScanResult) => {
    // 🖨 Print the "result" to browser console.
    console.log(result);
    // ✅ Handle success.
    // 😎 You can do whatever you want with the scanned result.
    setScannedResult(result?.data);
    //setCodbarra(result?.data);

  };

  const options = { pauseOnHover: true, closeButton: true }

  const obtenerContactos = async () => {
    try {
      const response = await axios.get(`${URL_API}?codbarra=${scannedResult}`);
      if (response.data.accesado) {
        if (response.data.accesado && response.data.accesado == 'N') {
          const responseup = await axios.put(`${URL_API}?codbarra=${scannedResult}`);
          Swal.fire({
            title: 'FULL ACCESO',
            icon: 'success',
            text: responseup.data.message,
            backdrop: false,
            showConfirmButton: true}).then((result) => {
              if (result.isConfirmed) {
                setScannedResult('0');
              }
          })
        } else {
          //toast.error(`Usuario ya ingreso a las : ${response.data.fecha}`, options);
          Swal.fire({
            title: 'FULL ACCESO',
            icon: 'error',
            text: `Usuario ya ingreso a las : ${response.data.fecha}`,
            backdrop: false,
            showConfirmButton: true}).then((result) => {
              if (result.isConfirmed) {
                setScannedResult('0');
              }
          })
          /* alert(`Usuario ya ingreso a las : ${response.data.fecha}`, );*/
        }
        //setScannedResult('0');
      }
    } catch (error) {
      console.error("Error al obtener los contactos:", error);
    }
  };

  /* const fetchProductos = async () => {
    try {
      const response = await fetch(`http://localhost:3001/api/productos/${scannedResult}`)
      if (!response.ok) {
        throw new Error('Error al obtener los datos del servidor!!')
      }
      const data = await response.json()
      alert('1');
      alert(data);
      alert('2');
    } catch (error) {
      console.log(`Codigo Inexistente para este evento!! ${codbarra}`);
    }
  }; */

  /* const updatetickets =  async () => {
    try {
      const response = await fetch(`http://localhost:3001/api/productos/${scannedResult}`)
      if (!response.ok) {
        throw new Error('Error al obtener los datos del servidor!!')
      }
      const data = await response.json()
      alert(data);
      const actualiza = await fetch(`http://localhost:3001/api/updatecodbarra/${scannedResult}`)
      if (!actualiza.ok) {
        throw new Error('Error al obtener los datos del servidor!!')
      }
      alert ('Bienvenido');
    } catch (error) {
      console.log(`Codigo Inexistente para este evento!! ${codbarra}`);
    }
  };
 */
  // Fail
  const onScanFail = (err: string | Error) => {
    // 🖨 Print the "err" to browser console.
    console.log(err);
  };
  /*  useEffect(() => {
     fetchProductos();
   }, [scannedResult]); */
  /* useEffect(() => {
    updatetickets();
  }, [scannedResult]); */

  useEffect(() => {
    if (videoEl?.current && !scanner.current) {
      // 👉 Instantiate the QR Scanner
      scanner.current = new QrScanner(videoEl?.current, onScanSuccess, {
        onDecodeError: onScanFail,
        // 📷 This is the camera facing mode. In mobile devices, "environment" means back camera and "user" means front camera.
        preferredCamera: "environment",
        // 🖼 This will help us position our "QrFrame.svg" so that user can only scan when qr code is put in between our QrFrame.svg.
        highlightScanRegion: true,
        // 🔥 This will produce a yellow (default color) outline around the qr code that we scan, showing a proof that our qr-scanner is scanning that qr code.
        highlightCodeOutline: true,
        // 📦 A custom div which will pair with "highlightScanRegion" option above 👆. This gives us full control over our scan region.
        overlay: qrBoxEl?.current || undefined,
      });

      // 🚀 Start QR Scanner
      scanner?.current
        ?.start()
        .then(() => setQrOn(true))
        .catch((err) => {
          if (err) setQrOn(false);
        });
    }

    // 🧹 Clean up on unmount.
    // 🚨 This removes the QR Scanner from rendering and using camera when it is closed or removed from the UI.
    return () => {
      if (!videoEl?.current) {
        scanner?.current?.stop();
      }
    };
  }, []);

  // ❌ If "camera" is not allowed in browser permissions, show an alert.
  useEffect(() => {
    if (!qrOn)
      alert(
        "Camera is blocked or not accessible. Please allow camera in your browser permissions and Reload."
      );
  }, [qrOn]);

  return (
    <div className="qr-reader">
      <ToastContainer limit={1} closeOnClick={true} />
      {/* QR */}
      <video ref={videoEl}></video>
      <div ref={qrBoxEl} className="qr-box">
        <img
          src={QrFrame}
          alt="Qr Frame"
          width={256}
          height={256}
          className="qr-frame"
        />
      </div>

      {/* Show Data Result if scan is success */}
      {scannedResult && (
        <p
          style={{
            position: "absolute",
            top: 0,
            left: 0,
            zIndex: 99999,
            color: "white",
          }}
        >
          Scanned Result: {scannedResult}
        </p>
      )}
    </div>
  );
};

export default QrReader;
