document.addEventListener("DOMContentLoaded", () => {
	const $resultados = document.querySelector("#resultado");
	Quagga.init({
		inputStream: {
			constraints: {
				width: 1920,
				height: 1080,
			},
			name: "Live",
			type: "LiveStream",
			target: document.querySelector('#contenedor'), // Pasar el elemento del DOM
		},
		decoder: {
			readers: ["code_39_reader"]
		}
	}, function (err) {
		if (err) {
			console.log(err);
			return
		}
		console.log("Iniciado correctamente");
		Quagga.start();
	});

	Quagga.onDetected((data) => {
                let leido = false;
		$resultados.textContent = data.codeResult.code;
		// Imprimimos todo el data para que puedas depurar
		console.log(data);
const codigo = data.codeResult.code;
  if (codigo && !leido) {
    leido = true;
    var parametros = {
      "codigo": codigo
    };
    $.ajax({
      data: parametros,
      url: "buscar.php",
      type: "post",
      success: function (response) {
        if (response == 'OK') {
          document.getElementById("aceptado").style.display = "block";
          document.getElementById("aceptado").innerHTML = "Bienvenid@";
          document.getElementById("noaceptado").style.display = "none";
        } else {
          document.getElementById("aceptado").style.display = "none";
          document.getElementById("noaceptado").style.display = "block";
          document.getElementById("noaceptado").innerHTML = response;
        }
      }
    });
    document.getElementById('codigo').value = '';
    setTimeout(5000);
    document.getElementById('codigo').focus();
  }
	});
Quagga.onProcessed(function (result) {
  var drawingCtx = Quagga.canvas.ctx.overlay,
    drawingCanvas = Quagga.canvas.dom.overlay;

  if (result) {
    if (result.boxes) {
      drawingCtx.clearRect(0, 0, parseInt(drawingCanvas.getAttribute("width")), parseInt(drawingCanvas.getAttribute("height")));
      result.boxes.filter(function (box) {
        return box !== result.box;
      }).forEach(function (box) {
        Quagga.ImageDebug.drawPath(box, { x: 0, y: 1 }, drawingCtx, { color: "green", lineWidth: 2 });
      });
    }

    if (result.box) {
      Quagga.ImageDebug.drawPath(result.box, { x: 0, y: 1 }, drawingCtx, { color: "#00F", lineWidth: 2 });
    }

    if (result.codeResult && result.codeResult.code) {
      Quagga.ImageDebug.drawPath(result.line, { x: 'x', y: 'y' }, drawingCtx, { color: 'red', lineWidth: 3 });
    }
  }
});
});
