<?php
include ($_SERVER['DOCUMENT_ROOT'].'/boletos/template/headertaquilla.php');   
?> 
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
 <main>
  <div class="container box">
   <h1 align="center">Maestro de Eventos</h1>
   <div class="table-responsive">
    <br />
    <div align="right">
     <button type="button" id="add_button" data-toggle="modal" data-target="#userModal" class="btn btn-info btn-lg">Agregar</button>
    </div>
    <br />
    <table id="user_data" class="table table-bordered table-striped">
     <thead>
      <tr>       
       <th>Nombre</th>
       <th>Descripcion</th>
       <th>Imagen</th>
       <th>Fecha</th>
       <th>Hora</th>
       <th>Precio</th>
       <th>Nro Evento</th>
       <th>Lugar</th>
       <th>Vs</th>
       <th>Status</th>
       <th width="5%">Edit</th>
       <th width="5%">Borrar</th>
      </tr>
     </thead>
    </table>
    
   </div>
  </div>
 

<div id="userModal" class="modal fade">
 <div class="modal-dialog">
  <form method="post" id="user_form" enctype="multipart/form-data">
   <div class="modal-content">
    <div class="modal-header">
     <button type="button" class="close" data-dismiss="modal">&times;</button>
     <h4 class="modal-title">Agregar Evento</h4>
    </div>
    <div class="modal-body">
     <label>Nombre</label>
     <input type="text" name="nombre" id="nombre" class="form-control" />
     <br />
     <label>Descripcion</label>
     <input type="text" name="descripcion" id="descripcion" class="form-control" />
     <br />
     <label>Select Image</label>
     <input type="file" name="imagen" id="imagen" />
     <span id="user_uploaded_image"></span>
     <br />
     <div class="row">
      <div class="col-xs-12 col-sm-6">
        <label>Fecha</label>
        <input type="date" name="fecha" id="fecha" class="form-control" />
      </div>
      <div class="col-xs-12 col-sm-6">
        <label>Hora</label>
        <input type="time" name="hora" id="hora" class="form-control" />
      </div>
     </div>
     <br />
     <div class="row">
      <div class="col-xs-12 col-sm-4">
        <label>Tipo Precio</label>
        <input type="numbre" name="tipo_precio" id="tipo_precio" class="form-control" />
      </div>
      <div class="col-xs-12 col-sm-4">
        <label>Nro Evento</label>
        <input type="numbre" name="nro_evento" id="nro_evento" class="form-control" />
      </div>
      <div class="col-xs-12 col-sm-4">
        <label>Lugar</label>
        <input type="numbre" name="venue_id" id="venue_id" class="form-control" />
      </div>
     </div>
     <br />
     <div class="row">
      <div class="col-xs-12 col-sm-6">
        <label>Vs</label>
        <input type="text" name="vs" id="vs" class="form-control" />
      </div>
      <div class="col-xs-12 col-sm-6">
        <label>Status</label>
        <input type="number" name="status" id="status" class="form-control" />
      </div>
     </div>
    </div>
    <div class="modal-footer">
     <input type="hidden" name="user_id" id="user_id" />
     <input type="hidden" name="operation" id="operation" />
     <input type="submit" name="action" id="action" class="btn btn-success" value="Add" />
     <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
    </div>
   </div>
  </form>
 </div>
</div>
</main>
<?php
//include ($_SERVER['DOCUMENT_ROOT'].'/boletos/template/footer.php');  
?>

<script type="text/javascript" language="javascript" >
$(document).ready(function(){
  
 $('#add_button').click(function(){
  $('#user_form')[0].reset();
  $('.modal-title').text("Agregar Evento");
  $('#action').val("Add");
  $('#operation').val("Add");
  $('#user_uploaded_image').html('');
 });
 var dataTable = $('#user_data').DataTable({
  "processing":true,
  "serverSide":true,
  "order":[],
  "ajax":{
   url:"fetch.php",
   type:"POST"
  },
  "columnDefs":[
   {
    "targets":[0, 3, 4],
    "orderable":false,
   },
  ],

 });
 $(document).on('submit', '#user_form', function(event){
  event.preventDefault();
  var nombre = $('#nombre').val();
  var descripcion = $('#descripcion').val();
  var extension = $('#imagen').val().split('.').pop().toLowerCase();
  if(extension != '')
  {
   if(jQuery.inArray(extension, ['gif','png','jpg','jpeg']) == -1)
   {
    alert("Invalid Image File");
    $('#imagen').val('');
    return false;
   }
  } 
  if(nombre != '' && descripcion != '')
  {
   $.ajax({
    url:"insert.php",
    method:'POST',
    data:new FormData(this),
    contentType:false,
    processData:false,
    success:function(data)
    {
     alert(data);
     $('#user_form')[0].reset();
     $('#userModal').modal('hide');
     dataTable.ajax.reload();
    }
   });
  }
  else
  {
   alert("Both Fields are Required");
  }
 });
 
 $(document).on('click', '.update', function(){
  var user_id = $(this).attr("id");
  $.ajax({
   url:"fetch_single.php",
   method:"POST",
   data:{user_id:user_id},
   dataType:"json",
   success:function(data)
   {
    $('#userModal').modal('show');
    $('#nombre').val(data.nombre);
    $('#descripcion').val(data.descripcion);
    $('.modal-title').text("Editar Evento");
    $('#user_id').val(user_id);
    $('#user_uploaded_image').html(data.imagen);
    $('#action').val("Edit");
    $('#operation').val("Edit");
   }
  })
 });
 
 $(document).on('click', '.delete', function(){
  var user_id = $(this).attr("id");
  if(confirm("¿Estás seguro de que quieres eliminar este evento?"))
  {
   $.ajax({
    url:"delete.php",
    method:"POST",
    data:{user_id:user_id},
    success:function(data)
    {
     alert(data);
     dataTable.ajax.reload();
    }
   });
  }
  else
  {
   return false; 
  }
 });
 
 
});
</script>