<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

require('configBD.php');
$metodo = $_SERVER['REQUEST_METHOD'];
$dirLocal = "fotos_amigos";
$extensionesPermitidas = array("jpg", "jpeg", "png", "gif");

switch ($metodo) {
    case 'GET':
        // Verificar si se ha proporcionado un ID en la cadena de consulta
        if (isset($_GET['codbarra'])) {
            // Obtener el ID de la cadena de consulta y escaparlo para evitar la inyección SQL
            $id = mysqli_real_escape_string($con, $_GET['codbarra']);

            $query = "SELECT id, codbarra, accesado, DATE_FORMAT(fecha, '%d/%l/%Y %H:%i:%s %p') AS fecha, cliente, tipo_localidad_id FROM codigos WHERE codbarra = '" . $id . "'";
            $resultado = mysqli_query($con, $query);

            // Verificar si se encontró el registro
            if (mysqli_num_rows($resultado) > 0) {
                // Si se encontró, obtener los datos y devolverlos como JSON
                $usuario = mysqli_fetch_assoc($resultado);
                echo json_encode($usuario);
            } else {
                // Si no se encontró el registro, devolver un mensaje de error
                echo json_encode(array('mensaje' => 'No se encontró ningún Ticket con el Codigo de barra proporcionado'));
            }
        } else {
            $query = "SELECT * FROM codigos ORDER BY codbarra DESC";
            $resultado = mysqli_query($con, $query);

            $usuarios = array();
            while ($fila = mysqli_fetch_assoc($resultado)) {
                $usuarios[] = $fila;
            }
            echo json_encode($usuarios);
        }
        break;

    case 'POST':

        if (
            isset($_POST["id"]) &&
            ($_SERVER['REQUEST_METHOD'] == "POST")
        ) {
            if (isset($_FILES['avatar'])) {
                $archivoTemporal = $_FILES['avatar']['tmp_name'];
                $nombreArchivo = $_FILES['avatar']['name'];

                $extension = strtolower(pathinfo($nombreArchivo, PATHINFO_EXTENSION));

                if (in_array($extension, $extensionesPermitidas)) {
                    // Generar un nombre único y seguro para el archivo
                    $nombreArchivo = substr(md5(uniqid(rand())), 0, 10) . "." . $extension;
                    $rutaDestino = $dirLocal . '/' . $nombreArchivo;

                    // Mover el archivo a la ubicación deseada
                    if (move_uploaded_file($archivoTemporal, $rutaDestino)) {
                        $nombre = ucwords($_POST['nombre']);
                        $email = trim($_POST['email']);
                        $telefono = trim($_POST['telefono']);
                        $id = trim($_POST['id']);

                        $query = "UPDATE $tbl_alumnos SET nombre='$nombre', email='$email', telefono='$telefono', avatar='$nombreArchivo' WHERE id=$id";
                        if (mysqli_query($con, $query)) {
                            echo json_encode(array('message' => 'Contacto actualizado correctamente'));
                        } else {
                            echo json_encode(array('error' => 'Error al actualizar contacto: ' . mysqli_error($con)));
                        }
                    } else {
                        echo json_encode(array('error' => 'Error al mover el archivo'));
                    }
                } else {
                    echo json_encode(array('error' => 'Tipo de archivo no permitido'));
                }
            } else {
                echo json_encode(array('error' => 'No se ha enviado ningún archivo o ha ocurrido un error al cargar el archivo'));
            }
        } else {
            // Verificar si se ha enviado un archivo
            if (isset($_FILES['avatar'])) {
                $archivoTemporal = $_FILES['avatar']['tmp_name'];
                $nombreArchivo = $_FILES['avatar']['name'];

                $extension = strtolower(pathinfo($nombreArchivo, PATHINFO_EXTENSION));

                if (in_array($extension, $extensionesPermitidas)) {
                    // Generar un nombre único y seguro para el archivo
                    $nombreArchivo = substr(md5(uniqid(rand())), 0, 10) . "." . $extension;
                    $rutaDestino = $dirLocal . '/' . $nombreArchivo;

                    // Mover el archivo a la ubicación deseada
                    if (move_uploaded_file($archivoTemporal, $rutaDestino)) {
                        $nombre = ucwords($_POST['nombre']);
                        $email = trim($_POST['email']);
                        $telefono = trim($_POST['telefono']);
                        $query = "INSERT INTO $tbl_alumnos (nombre, email, telefono, avatar) VALUES ('$nombre', '$email', '$telefono', '$nombreArchivo')";
                        if (mysqli_query($con, $query)) {
                            echo json_encode(array('message' => 'Nuevo amigo creado correctamente'));
                        } else {
                            echo json_encode(array('error' => 'Error al crear amigo: ' . mysqli_error($con)));
                        }
                    } else {
                        echo json_encode(array('error' => 'Error al mover el archivo'));
                    }
                } else {
                    echo json_encode(array('error' => 'Tipo de archivo no permitido'));
                }
            } else {
                echo json_encode(array('error' => 'No se ha enviado ningún archivo o ha ocurrido un error al cargar el archivo'));
            }
        }
        break;

    case 'PUT':
        if (isset($_GET['codbarra'])) {
            // Obtener el ID de la cadena de consulta y escaparlo para evitar la inyección SQL
            $id = mysqli_real_escape_string($con, $_GET['codbarra']);

            $query = "UPDATE codigos SET accesado='S', fecha=now() WHERE codbarra='" . $id . "'";
            
            $query2 = "SELECT tipo_localidad_id FROM codigos WHERE codbarra='" . $id . "'";
            $res = mysqli_query($con, $query2);
            $row = mysqli_fetch_assoc($res);
            
            
            
            $query4 = "SELECT count(*) cant FROM codigos WHERE accesado='S'";
            $res3 = mysqli_query($con, $query4);
            $row3 = mysqli_fetch_assoc($res3);
            if (mysqli_query($con, $query)) {
                /*$query3 = "SELECT count(*) cant FROM codigos WHERE tipo_localidad_id='" . $row["tipo_localidad_id"] . "'
                           and accesado='S'";*/
                $query3 = "SELECT B.nombre, count(*) cant FROM codigos A inner join tipo_localidad B on A.tipo_localidad_id=B.id
                           and accesado='S' group by B.nombre";
                $res2 = mysqli_query($con, $query3);
                foreach ($res2 as $row2) {
                    $total = $total . $row2['nombre'] . ':' . $row2['cant'] . '  ' ;
                }
                
            $row2 = mysqli_fetch_assoc($res2);
                echo json_encode(array('message' => 'BIENVENIDO' ,  'tl' => $row["tipo_localidad_id"],  
                                       'canttl' => $total, 'total' => $row3["cant"]));
            } else {
                echo json_encode(array('message' => 'Error al actualizar TICKET: ' . mysqli_error($con)));
            }
            break;
        }
    case 'DELETE':
        $id = $_GET['id'];

        // Obtener el nombre del archivo de imagen asociado al contacto
        $query = "SELECT avatar FROM $tbl_alumnos WHERE id=$id";
        $result = mysqli_query($con, $query);
        $row = mysqli_fetch_assoc($result);
        $avatarName = $row['avatar'];

        // Eliminar la entrada del contacto de la base de datos
        $deleteQuery = "DELETE FROM $tbl_alumnos WHERE id=$id";
        if (mysqli_query($con, $deleteQuery)) {
            // Eliminar el archivo de imagen si existe
            if ($avatarName) {
                $filePath = $dirLocal . '/' . $avatarName;
                if (file_exists($filePath)) {
                    unlink($filePath); // Eliminar el archivo de imagen
                }
            }

            echo json_encode(array('message' => 'Amigo eliminado correctamente'));
        } else {
            echo json_encode(array('error' => 'Error al eliminar amigo: ' . mysqli_error($con)));
        }
        break;


    default:
        echo json_encode(array('error' => 'Método no permitido'));
        break;
}

mysqli_close($con);